<?xml version="1.0" ?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:template match="/ResOrgExportFile">
<xsl:comment> saved from url=(0014)about:internet </xsl:comment><xsl:text>&#13;&#10;</xsl:text>
   <html>
      <title>Symbols Report</title>
      <style>
	      body			         { font-family: Verdana, Arial, Helvetica, sans-serif; font-size: 10pt; color: #000080; }
	      h1        			 { font-size: 14pt; font-weight: bold; } 
	      table     			 { font-size: 8pt; }
	      .table_caption		 { text-align: left; font-size: 10pt; font-weight: bold; }
	      .count			     { font-size: 8pt; font-style: italic; color: #0000ff; }	
      </style>

<script language="JavaScript">

function collapsenode(item)
{
        if (item.style.display == '')
        {
                item.style.display = 'none';
        }
        else
        {
                item.style.display = '';
        }
}
</script>    

<script language="JavaScript" >
//-----------------------------------------------------------------------------
// sortTable(id, col, rev)
//
//  id  - ID of the TABLE, TBODY, THEAD or TFOOT element to be sorted.
//  col - Index of the column to sort, 0 = first column, 1 = second column,
//        etc.
//  rev - If true, the column is sorted in reverse (descending) order
//        initially.
//
// Notes:
//   1.  The first column (index 0) is used as a secondary sort column and
//       always sorted in ascending order.
//
//   2.  This code is based on the "Table Sort Demo" code by Mike Hall
//       (http://www.brainjar.com) and is used with the author's consent
//-----------------------------------------------------------------------------

function sortTable(id, col, rev)
{
  // Get the table or table section to sort.
  var tblEl = document.getElementById(id);

  // The first time this function is called for a given table, set up an
  // array of reverse sort flags.

  if (tblEl.reverseSort == null)
  {
    tblEl.reverseSort = new Array();

    // Also, assume the team name column is initially sorted.
    tblEl.lastColumn = 0;
  }

  // If this column has not been sorted before, set the initial sort direction.
  if (tblEl.reverseSort[col] == null)
    tblEl.reverseSort[col] = rev;

  // If this column was the last one sorted, reverse its sort direction.
  if (col == tblEl.lastColumn)
    tblEl.reverseSort[col] = !tblEl.reverseSort[col];

  // Remember this column as the last one sorted.
  tblEl.lastColumn = col;

  // Set the table display style to "none" - necessary for Netscape 6 
  // browsers.

  var oldDsply = tblEl.style.display;
  tblEl.style.display = "none";

  // Sort the rows based on the content of the specified column using a
  // selection sort.
  var tmpEl;
  var i, j;
  var minVal, minIdx;
  var testVal;
  var cmp;

  for (i = 0; i &lt; tblEl.rows.length - 1; i++)
  {
    // Assume the current row has the minimum value.
    minIdx = i;
    minVal = getTextValue(tblEl.rows[i].cells[col]);

    // Search the rows that follow the current one for a smaller value.
    for (j = i + 1; j &lt; tblEl.rows.length; j++)
	{
      testVal = getTextValue(tblEl.rows[j].cells[col]);
      cmp = compareValues(minVal, testVal);

      // Negate the comparison result if the reverse sort flag is set.
      if (tblEl.reverseSort[col])
        cmp = -cmp;

      // Sort by the second column if those values are equal.
      if (cmp == 0 &amp;&amp; col != 0)
        cmp = compareValues(getTextValue(tblEl.rows[minIdx].cells[1]),
                            getTextValue(tblEl.rows[j].cells[1]));

      // If this row has a smaller value than the current minimum, remember its
      // position and update the current minimum value.
      if (cmp &gt; 0)
	  {
        minIdx = j;
        minVal = testVal;
      }
    }

    // By now, we have the row with the smallest value. Remove it from the
    // table and insert it before the current row.

    if (minIdx &gt; i)
	{
      tmpEl = tblEl.removeChild(tblEl.rows[minIdx]);
      tblEl.insertBefore(tmpEl, tblEl.rows[i]);
    }
  }

  // Set rankings.
  setRanks(tblEl, col, rev);

  // Restore the table's display style.
  tblEl.style.display = oldDsply;

  return false;
}

//-----------------------------------------------------------------------------
// Functions to get and compare values during a sort.
//-----------------------------------------------------------------------------

// This code is necessary for browsers that don't reflect the DOM constants
// (like IE).

if (document.ELEMENT_NODE == null)
{
  document.ELEMENT_NODE = 1;
  document.TEXT_NODE = 3;
}

function getTextValue(el)
{
  var i;
  var s;

  // Find and concatenate the values of all text nodes contained within the element.

  s = "";
  for (i = 0; i &lt; el.childNodes.length; i++)
    if (el.childNodes[i].nodeType == document.TEXT_NODE)
      s += el.childNodes[i].nodeValue;
    else if (el.childNodes[i].nodeType == document.ELEMENT_NODE &amp;&amp;
             el.childNodes[i].tagName == "BR")
      s += " ";
    else
      // Use recursion to get text within sub-elements.
      s += getTextValue(el.childNodes[i]);

  return normalizeString(s);
}

function compareValues(v1, v2)
{
  var f1, f2;

  // If the values are numeric, convert them to floats.
  f1 = parseFloat(v1);
  f2 = parseFloat(v2);

  if (!isNaN(f1) &amp;&amp; !isNaN(f2))
  {
    v1 = f1;
    v2 = f2;
  }

  // Compare the two values.
  if (v1 == v2)
    return 0;

  if (v1 &gt; v2)
    return 1

  return -1;
}

// Regular expressions for normalizing white space.
var whtSpEnds = new RegExp("^\\s*|\\s*$", "g");
var whtSpMult = new RegExp("\\s\\s+", "g");

function normalizeString(s)
{
  s = s.replace(whtSpMult, " ");  // Collapse any multiple whites space.
  s = s.replace(whtSpEnds, "");   // Remove leading or trailing white space.

  return s;
}


//-----------------------------------------------------------------------------
// Functions to update the table appearance after a sort.
//-----------------------------------------------------------------------------

// Style class names.
var rowClsNm = "alternateRow";
var colClsNm = "sortedColumn";

// Regular expressions for setting class names.
var rowTest = new RegExp(rowClsNm, "gi");
var colTest = new RegExp(colClsNm, "gi");

function setRanks(tblEl, col, rev)
{
  // Determine whether to start at the top row of the table and go down or
  // at the bottom row and work up. This is based on the current sort

  // direction of the column and its reversed flag.

  var i    = 0;
  var incr = 1;

  if (tblEl.reverseSort[col])
    rev = !rev;

  if (rev)
  {
    incr = -1;
    i = tblEl.rows.length - 1;
  }

  // Now go through each row in that direction and assign it a rank by
  // counting 1, 2, 3...
  var count   = 1;
  var rank    = count;
  var curVal;
  var lastVal = null;

  // Note that this loop is skipped if the table was sorted on the name column.
  while (col &gt; 0 &amp;&amp; i &gt;= 0 &amp;&amp; i &lt; tblEl.rows.length)
  {
    // Get the value of the sort column in this row.
    curVal = getTextValue(tblEl.rows[i].cells[col]);

    // On rows after the first, compare the sort value of this row to the
    // previous one. If they differ, update the rank to match the current row
    // count. (If they are the same, this row will get the same rank as the
    // previous one.)
    if (lastVal != null &amp;&amp; compareValues(curVal, lastVal) != 0)
        rank = count;

    // Set the rank for this row.
    tblEl.rows[i].rank = rank;

    // Save the sort value of the current row for the next time around and bump
    // the row counter and index.
    lastVal = curVal;
    count++;
    i += incr;
  }

  // Now go through each row (from top to bottom) and display its rank. Note
  // that when two or more rows are tied, the rank is shown on the first of
  // those rows only.

  var rowEl, cellEl;
  var lastRank = 0;

  // Go through the rows from top to bottom.
  for (i = 0; i &lt; tblEl.rows.length; i++)
  {
    rowEl = tblEl.rows[i];
    cellEl = rowEl.cells[0];
  }
}
</script>
	  
      <!-- The real stuff starts here -->
      <table width="100%" border="0"><tbody>
        <tr>
          <td class="tableheadingbgcolour" style="BORDER-TOP: blue thin ridge; BACKGROUND: lightblue; BORDER-BOTTOM: blue thin ridge" colSpan="2">
			 <br/>
			 <span class="titlebartext"><h1 align="center">Symbols Report</h1></span>
	      </td>
        </tr>
        <tr>
		  <br/><br/>
          <table border="0" width="100%" cellpadding="5" cellspacing="5">
	        <thead>
		      <tr>
                <br/><br/>
                <h3 align="left">Symbol Files</h3>
              </tr>
              <tr>
                <th align="left"><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  0, false);">PathName</a></th>
                <th><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  1, false);">Symbols</a></th>
                <th align="center" width="80"><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  2, false);">Resources /<br/>Controls</a></th>
                <th align="center" width="80"><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  3, false);">Commands</a></th>
                <th><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  4, false);">Internal<br/>Conflicts</a></th>
                <th><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  5, false);">External<br/>Conflicts</a></th>
                <th><a href="" onclick="this.blur(); return sortTable('FilesTableBody',  6, false);">Out of Range</a></th>
              </tr>
	  		</thead>
			<tbody id="FilesTableBody">
              <xsl:for-each select="File">
                <tr>
                  <td><xsl:value-of select="PathName" /><br/>(Resource File: <xsl:value-of select="ResourceFile" />)</td>
                  <td align="center"><xsl:value-of select="count(Symbols/Symbol)"/></td>
				  <td align="center">
				    <xsl:choose>
                      <xsl:when test="Metrics/Resources/MaxValue=0">None</xsl:when>
                      <xsl:otherwise><xsl:value-of select="Metrics/Resources/MinValue" />-<xsl:value-of select="Metrics/Resources/MaxValue" /></xsl:otherwise>
                    </xsl:choose>
	  			  </td>
				  <td align="center">
				    <xsl:choose>
                      <xsl:when test="Metrics/Commands/MaxValue=0">None</xsl:when>
                      <xsl:otherwise><xsl:value-of select="Metrics/Commands/MinValue" />-<xsl:value-of select="Metrics/Commands/MaxValue" /></xsl:otherwise>
                    </xsl:choose>
				  </td>
                  <td align="center">
                    <xsl:choose>
                      <xsl:when test="Metrics/Conflicts/Internal>0"><font color="red"><b><xsl:value-of select="Metrics/Conflicts/Internal" /></b></font></xsl:when>
                      <xsl:otherwise><xsl:value-of select="Metrics/Conflicts/Internal" /></xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td align="center">
                    <xsl:choose>
                      <xsl:when test="Metrics/Conflicts/External>0"><font color="red"><b><xsl:value-of select="Metrics/Conflicts/External" /></b></font></xsl:when>
                      <xsl:otherwise><xsl:value-of select="Metrics/Conflicts/External" /></xsl:otherwise>
                    </xsl:choose>
                  </td>
                  <td align="center">
                    <xsl:choose>
                      <xsl:when test="Options/CheckForOutOfRangeSymbols>0">
                        <xsl:choose>
                          <xsl:when test="Metrics/OutOfRangeSymbols>0"><font color="red"><b><xsl:value-of select="Metrics/OutOfRangeSymbols" /></b></font></xsl:when>
                          <xsl:otherwise><xsl:value-of select="Metrics/OutOfRangeSymbols" /></xsl:otherwise>
                        </xsl:choose>
					  </xsl:when>
					  <xsl:otherwise>n/a</xsl:otherwise>
                    </xsl:choose>
                  </td>
                </tr>
              </xsl:for-each>
			</tbody>
          </table>
          <br/>
          <br/>

          <!-- The properties for each file follow -->
          <xsl:for-each select="File">
            <tr>
			  <xsl:variable name="fileproperties" select="concat('FileProperties_', @uid)" />
              <xsl:variable name="fileproperties_id" select="concat($fileproperties, '_h1')" />
              <font class="table_caption">
			  
                <!-- <a id="DynMessLink" name="FileProperties" href="#" onclick="collapsenode(FileProperties_h1);">File Properties</a> -->
                <a>
                  <xsl:attribute name="id">DynMessLink</xsl:attribute>
                  <xsl:attribute name="name"><xsl:value-of select="$fileproperties" /></xsl:attribute>
                  <xsl:attribute name="href">#</xsl:attribute>
                  <xsl:attribute name="onclick">collapsenode(<xsl:value-of select="$fileproperties_id" />);</xsl:attribute>
                  <xsl:value-of select="PathName" />
                </a>
				 
              </font>
              <br />
              <br />
              <table border="0" width="100%" cellpadding="0" cellspacing="0">

                <!-- <tr id="FileProperties_h1" align="left"> -->
                <tr>
                  <xsl:attribute name="id"><xsl:value-of select="$fileproperties_id" /></xsl:attribute>
                  <xsl:attribute name="align">left</xsl:attribute>
				  <xsl:attribute name="style">display:none</xsl:attribute>
				  <th>
                    <table border="0" width="100%" cellpadding="0" cellspacing="0">
					  <tr>
  					    <td>
					      <table border="0" width="10px" cellpadding="0" cellspacing="0"></table>
  					    </td>
					    <td>
                          <xsl:call-template name="symbol_metrics_template" />
  					      <br/>
             		      <xsl:call-template name="next_symbol_values_template" />
	     				  <br/>
                          <xsl:call-template name="symbols_template" />
				     	  <br/>
					    </td>
					  </tr>
					</table>
				  </th>
                </tr>
              </table>
            </tr>
          </xsl:for-each>
		</tr>
      </tbody></table>

      <hr width="100%" />
        <small><i>Report produced by <xsl:value-of select="/ResOrgExportFile/Application/@name" />
           version <xsl:value-of select="/ResOrgExportFile/Application/Version" /> at <xsl:value-of select="/ResOrgExportFile/Timestamp" /><br/>
           <br/>
		   <a>
             <xsl:attribute name="href"><xsl:value-of select="/ResOrgExportFile/Application/WebUrl" /></xsl:attribute>
             <xsl:attribute name="target">_blank</xsl:attribute>
             <xsl:value-of select="/ResOrgExportFile/Application/WebUrl" />
           </a>
		</i></small>
    </html>
  </xsl:template>


  <!-- Template to generate the "Metrics" table -->
  <xsl:template name="symbol_metrics_template" match="*">
    <xsl:variable name="metrics" select="concat('Metrics_', @uid)" />
	<xsl:variable name="metrics_id" select="concat($metrics, '_h1')" />
   	<xsl:variable name="metricstablebody" select="concat('MetricsTableBody_', @uid)" />
    <font class="table_caption">

      <!-- <a id="DynMessLink" name="Metrics" href="#" onclick="collapsenode(Metrics_h1);">FileMetrics</a> -->
      <a>
        <xsl:attribute name="id">DynMessLink</xsl:attribute>
        <xsl:attribute name="name"><xsl:value-of select="$metrics" /></xsl:attribute>
        <xsl:attribute name="href">#</xsl:attribute>
        <xsl:attribute name="onclick">collapsenode(<xsl:value-of select="$metrics_id" />);</xsl:attribute>
        Metrics
      </a>
    </font>
    <br />
    <br />
    <table border="0" width="75%" cellpadding="0" cellspacing="0">
      <!-- <tr id="Metrics_h1" align="left"> -->
      <tr>
        <xsl:attribute name="id"><xsl:value-of select="$metrics_id" /></xsl:attribute>
        <xsl:attribute name="align">left</xsl:attribute>
        <th>
          <table border="0" cellpadding="4" cellspacing="0">
		    <thead>
              <tr>
                <th align="left"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$metricstablebody" />',  0, false);</xsl:attribute>
				  Type
                </a></th>
                <th align="center"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$metricstablebody" />',  1, false);</xsl:attribute>
				  Count
                </a></th>
                <th align="center"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$metricstablebody" />',  2, false);</xsl:attribute>
				  Min Value
                </a></th>
                <th align="center"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$metricstablebody" />',  3, false);</xsl:attribute>
				  Max Value
                </a></th>
              </tr>
              <tr>
                <td align="left"></td>
                <td align="center"></td>
                <td align="center"></td>
                <td align="center"></td>
  	          </tr>
		    </thead>
			<tbody>
    		  <xsl:attribute name="id"><xsl:value-of select="$metricstablebody" /></xsl:attribute>
              <tr>
                <td align="left">Bitmaps (IDB_):</td>
                <td align="center"><xsl:value-of select="Metrics/Bitmaps/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Icons (IDI_):</td>
                <td align="center"><xsl:value-of select="Metrics/Icons/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Accelerators (IDK_):</td>
                <td align="center"><xsl:value-of select="Metrics/Accelerators/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Menus (IDM_):</td>
                <td align="center"> <xsl:value-of select="Metrics/Menus/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Prompts (IDP_):</td>
                <td align="center"> <xsl:value-of select="Metrics/Prompts/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Strings (IDS_):</td>
                <td align="center"><xsl:value-of select="Metrics/Strings/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Toolbars (IDT_):</td>
                <td align="center"><xsl:value-of select="Metrics/Toolbars/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Controls (IDC_):</td>
                <td align="center"><xsl:value-of select="Metrics/Controls/Count" /></td>
                <td align="center"></td>
                <td align="center"></td>
              </tr>
              <tr>
                <td align="left">Other Resources:</td>
                <td align="center"><xsl:value-of select="Metrics/Resources/Count" /></td>
                <td align="center"><xsl:value-of select="Metrics/Resources/MinValue" /></td>
                <td align="center"><xsl:value-of select="Metrics/Resources/MaxValue" /></td>
              </tr>
              <tr>
                <td align="left">Commands (ID_):</td>
                <td align="center"><xsl:value-of select="Metrics/Commands/Count" /></td>
                <td align="center"><xsl:value-of select="Metrics/Commands/MinValue" /></td>
                <td align="center"><xsl:value-of select="Metrics/Commands/MaxValue" /></td>
              </tr>
			</tbody>
          </table>
          <br />
          <br />
        </th>
      </tr>
    </table>
  </xsl:template>

  
  <!-- Template to generate the "Next Symbol Properties" table -->
  <xsl:template name="next_symbol_values_template" match="*">
    <xsl:variable name="nextsymbolvalues" select="concat('NextSymbolValues_', @uid)" />
	<xsl:variable name="nextsymbolvalues_id" select="concat($nextsymbolvalues, '_h1')" />
   	<xsl:variable name="nextsymbolvaluestablebody" select="concat('NextSymbolValuesTableBody_', @uid)" />

    <font class="table_caption">
      <!-- <a id="DynMessLink" name="NextSymbolValues" href="#" onclick="collapsenode(NextSymbolValues_h1);">Next Symbol Values</a> -->
      <a>
       <xsl:attribute name="id">DynMessLink</xsl:attribute>
        <xsl:attribute name="name"><xsl:value-of select="$nextsymbolvalues" /></xsl:attribute>
        <xsl:attribute name="href">#</xsl:attribute>
        <xsl:attribute name="onclick">collapsenode(<xsl:value-of select="$nextsymbolvalues_id" />);</xsl:attribute>
        Next Symbol Values
      </a>
    </font>

    <br />
    <br />
    <table border="0" width="75%" cellpadding="0" cellspacing="0">
      <tr>
        <xsl:attribute name="id"><xsl:value-of select="$nextsymbolvalues_id" /></xsl:attribute>
        <xsl:attribute name="align">left</xsl:attribute>
        <!-- <tr id="NextSymbolValues_h1" align="left"> -->
        <th>
          <table border="0" cellpadding="4" cellspacing="0">
		    <thead>
              <tr>
                <th align="left"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$nextsymbolvaluestablebody" />',  0, false);</xsl:attribute>
				  Symbol Type
                </a></th>
                <th align="center"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$nextsymbolvaluestablebody" />',  1, false);</xsl:attribute>
				  Next Symbol Value
                </a></th>
              </tr>
			</thead>
			<tbody>
			  <xsl:attribute name="id"><xsl:value-of select="$nextsymbolvaluestablebody" /></xsl:attribute>
              <tr>
                <td align="left">Resources:</td>
                <td align="center"><xsl:value-of select="NextSymbols/Resources" /></td>
              </tr>
              <tr>
                <td align="left">Controls: </td>
                <td align="center"><xsl:value-of select="NextSymbols/Controls" /></td>
              </tr>
              <tr>
                <td align="left">Commands: </td>
                <td align="center"><xsl:value-of select="NextSymbols/Commands" /></td>
              </tr>
              <tr>
                <td align="left">Editable Symbols:</td>
                <td align="center"><xsl:value-of select="NextSymbols/EditableSymbols" /></td>
              </tr>
			</tbody>
          </table>
          <br />
          <br />
        </th>
      </tr>
    </table>
  </xsl:template>

  
  <!-- Template to produce the "Symbols" table -->
  <xsl:template name="symbols_template" match="*">
    <xsl:variable name="symbols" select="concat('Symbols_', @uid)" />
    <xsl:variable name="symbols_id" select="concat($symbols, '_h1')" />
    <font class="table_caption">

      <!-- <a id="DynMessLink" name="Symbols" href="#" onclick="collapsenode(Symbols_h1);">Symbols</a> -->
      <a>
        <xsl:attribute name="id">DynMessLink</xsl:attribute>
        <xsl:attribute name="name"><xsl:value-of select="$symbols" /></xsl:attribute>
        <xsl:attribute name="href">#</xsl:attribute>
        <xsl:attribute name="onclick">collapsenode(<xsl:value-of select="$symbols_id" />);</xsl:attribute>
        Symbols
      </a>
    </font>
    <br />
    <br />
    <table border="0" width="75%" cellpadding="0" cellspacing="0">
      <!-- <tr id="Symbols_h1" align="left" style="display:none"> -->
      <tr>
        <xsl:attribute name="id"><xsl:value-of select="$symbols_id" /></xsl:attribute>
	    <xsl:attribute name="align">left</xsl:attribute>
        <xsl:attribute name="style">display:none</xsl:attribute>
        <th>
          <table border="0" cellpadding="4" cellspacing="0">
   		    <xsl:variable name="symbolstablebody" select="concat('SymbolsTableBody_', @uid)" />
		    <thead>
              <tr>
                <th align="left"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
			      <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  0, false);</xsl:attribute>
				  Name
				</a></th>
                <th align="left"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
				  <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  1, false);</xsl:attribute>
                  Type
				</a></th>
                <th align="left"><a>
     	          <xsl:attribute name="href"></xsl:attribute>
		          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  2, false);</xsl:attribute>
                  Value
				</a></th>
                <xsl:choose>
  				  <xsl:when test="Options/CheckForOutOfRangeSymbols>0">
                    <th align="center"><a>
     	              <xsl:attribute name="href"></xsl:attribute>
			          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  3, false);</xsl:attribute>
				      Out of Range?
				    </a></th>
                    <th align="center"><a>
     	              <xsl:attribute name="href"></xsl:attribute>
			          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  4, false);</xsl:attribute>
				      Read Only?
				    </a></th>
                    <th align="left"><a>
     	              <xsl:attribute name="href"></xsl:attribute>
			          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  5, false);</xsl:attribute>
				      Conflicts
                    </a></th>
			      </xsl:when>
				  <xsl:otherwise>
                    <th align="center"><a>
     	              <xsl:attribute name="href"></xsl:attribute>
			          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  3, false);</xsl:attribute>
				      Read Only?
				    </a></th>
                    <th align="left"><a>
     	              <xsl:attribute name="href"></xsl:attribute>
			          <xsl:attribute name="onclick">this.blur(); return sortTable('<xsl:value-of select="$symbolstablebody" />',  4, false);</xsl:attribute>
				      Conflicts
                    </a></th>
				  </xsl:otherwise>
	     	    </xsl:choose>
              </tr>
			</thead>
			<tbody>
			  <xsl:attribute name="id"><xsl:value-of select="$symbolstablebody" /></xsl:attribute>
			  <xsl:for-each select="Symbols/Symbol">
	            <xsl:call-template name="symbol_properties_template">
			      <xsl:with-param name="symbol" select="*"/>
                </xsl:call-template>
              </xsl:for-each>
			</tbody>
          </table>
          <br />
          <br />
        </th>
      </tr>
    </table>
  </xsl:template>

  
  <!-- Template to spit out a single row of symbol properties -->
  <xsl:template name="symbol_properties_template" match="*">
    <tr>
      <!-- <xsl:if test="Conflicts/@total &gt; 0"><xsl:element name="b"/></xsl:if> -->
      <td align="left">

        <!-- Add an anchor for the symbol (using it's name) so conflicts can reference it -->
	    <xsl:variable name="symbolanchor" select="concat(@name, '_', @uid)" />
        <a>
          <xsl:attribute name="name">
            <xsl:value-of select="$symbolanchor" />
          </xsl:attribute>
        </a>
        <xsl:value-of select="@name" />
      </td>
      <td align="left"><xsl:value-of select="Type" /></td>
      <td align="left"><xsl:value-of select="Value" /></td>
      <xsl:if test="OutOfRange!='n/a'">
        <td align="center">
          <xsl:choose>
            <xsl:when test="OutOfRange>0"><font color="red"><b>Yes</b></font></xsl:when>
            <xsl:otherwise>No</xsl:otherwise>
          </xsl:choose>
        </td>
	  </xsl:if>
      <td align="center">
        <xsl:choose>
          <xsl:when test="ReadOnly=1"><b>Yes</b></xsl:when>
          <xsl:when test="ReadOnly=0">No</xsl:when>
          <xsl:otherwise>???</xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:for-each select="Conflicts/Symbol">
    	  <xsl:variable name="conflictingsymbolanchor" select="concat('#', @name, '_', @uid)" />
          <a>
            <xsl:attribute name="href"><xsl:value-of select="$conflictingsymbolanchor" /></xsl:attribute>
            <xsl:value-of select="@name" />
          </a>
          <br />
        </xsl:for-each>
      </td>
      <!-- <xsl:if test="Conflicts/@total &gt; 0"><xsl:element name="/b"/></xsl:if> -->
    </tr>
  </xsl:template>

</xsl:stylesheet>
